package data.missions.businessasusual;

import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.scripts.SWPModPlugin;

public class MissionDefinition implements MissionDefinitionPlugin {

    @Override
    public void defineMission(MissionDefinitionAPI api) {
        api.initFleet(FleetSide.PLAYER, "THI", FleetGoal.ATTACK, false, 2);
        api.initFleet(FleetSide.ENEMY, "ISA", FleetGoal.ATTACK, true, 4);

        api.setFleetTagline(FleetSide.PLAYER, "Protector Group Qishi");
        api.setFleetTagline(FleetSide.ENEMY, "Imperial Task Force");

        if (!SWPModPlugin.tiandongExists) {
            api.addBriefingItem("TIANDONG HEAVY INDUSTRIES REQUIRED");
            api.addBriefingItem("Download Tiandong Heavy Industries to play this mission!");
        }

        if (!SWPModPlugin.imperiumExists) {
            api.addBriefingItem("INTERSTELLAR IMPERIUM REQUIRED");
            api.addBriefingItem("Download Interstellar Imperium to play this mission!");
        }

        if (!SWPModPlugin.tiandongExists || !SWPModPlugin.imperiumExists) {
            return;
        } else {
            api.addBriefingItem("Defeat the Imperial forces");
        }

        api.addToFleet(FleetSide.PLAYER, "tiandong_wuzhang_Standard", FleetMemberType.SHIP, "THI Yinjing", true);
        api.addToFleet(FleetSide.PLAYER, "tiandong_shouren_Standard", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "tiandong_dingjun_Assault", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "tiandong_hanzhong_Standard", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "tiandong_hanzhong_Closesupport", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "tiandong_hujing_Standard", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "tiandong_hujing_Assault", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "tiandong_guan_du_Closesupport", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "tiandong_tuolu_Firesupport", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "tiandong_wujun_Standard", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "tiandong_wujun_Assault", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "tiandong_nanzhong_Balanced", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "tiandong_nanzhong_Balanced", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "tiandong_nanzhong_Standoff", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.PLAYER, "tiandong_nanzhong_Standoff", FleetMemberType.SHIP, false);

        api.addToFleet(FleetSide.ENEMY, "ii_dictator_eli", FleetMemberType.SHIP, "ISA Augustus", false);
        api.addToFleet(FleetSide.ENEMY, "ii_dictator_sta", FleetMemberType.SHIP, "ISA Julius", false);
        api.addToFleet(FleetSide.ENEMY, "ii_malleus_pd", FleetMemberType.SHIP, "ISA Nero", false);
        api.addToFleet(FleetSide.ENEMY, "ii_falcon_i_eli", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_falcon_i_eli", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_princeps_def", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_interrex_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_interrex_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_interrex_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_decurion_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_decurion_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_decurion_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_wolf_i_cs", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_wolf_i_cs", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_wolf_i_cs", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_basileus_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_basileus_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_basileus_sta", FleetMemberType.SHIP, false);

        float width = 16000f;
        float height = 22000f;
        api.initMap(-width / 2f, width / 2f, -height / 2f, height / 2f);

        for (int i = 0; i < 15; i++) {
            float x = (float) Math.random() * width - width / 2;
            float y = (float) Math.random() * height - height / 2;
            float radius = 100f + (float) Math.random() * 900f;
            api.addNebula(x, y, radius);
        }

        float minX = -width / 2f;
        float minY = -height / 2f;

        api.addNebula(minX + width * 0.3f, minY + height * 0.5f, 2000);
        api.addNebula(minX + width * 0.4f, minY + height * 0.5f, 2500);
        api.addNebula(minX + width * 0.5f, minY + height * 0.4f, 3000);
        api.addNebula(minX + width * 0.5f, minY + height * 0.5f, 3500);
        api.addNebula(minX + width * 0.5f, minY + height * 0.6f, 3000);
        api.addNebula(minX + width * 0.6f, minY + height * 0.5f, 2500);
        api.addNebula(minX + width * 0.7f, minY + height * 0.5f, 2000);

        api.addObjective(minX + width * 0.75f, minY + height * 0.4f, "sensor_array");
        api.addObjective(minX + width * 0.75f, minY + height * 0.6f, "sensor_array");
        api.addObjective(minX + width * 0.5f, minY + height * 0.3f, "comm_relay");
        api.addObjective(minX + width * 0.5f, minY + height * 0.7f, "comm_relay");
        api.addObjective(minX + width * 0.25f, minY + height * 0.5f, "nav_buoy");

        api.addAsteroidField(minX + width * 0.5f, minY + height, 270, width,
                             20f, 70f, 50);

        api.addPlanet(0, 0, 300f, "water", 0f, true);
    }
}
